<?php 
/**
 *
 * @link       https://advancedplugins.com
 * @since      1.1.2
 * @author     Your Name office@advancedplugins.com
 */
	/* Get the neccesary data */

	$all_image_sizes = Advanced_Speed_Optimizer_Functions::get_all_image_sizes();
	$compress_future_images = (int)get_option('compress_future_images', 0);
	$compression_quality_arr = array(60,70,80,90,91,92,93,94,95,96,97,98,99,100);
	$compression_quality = (int)get_option('compression_quality', 70);
	$compression_backup = (int)get_option('compression_backup', 0);

?>

<div id="ap-image-compression" class="ap_wrapper bootstrap  ">
   <div class="tab-content ">
      <div id="regenerate" class="tab-pane active">

	<div class="panel">
		   <div class="panel-heading"><?php esc_html_e('Info', Advanced_Speed_Optimizer::$plugin_name ) ?></div>
				<div class="alert alert-warning">
					<p><strong><?php esc_html_e('Please read the documentation before you compress the images to understand the optimal process to compress the images, you can do this by pressing the `Documentation` button in the plugin menu', Advanced_Speed_Optimizer::$plugin_name ) ?></strong></p>
					<p><?php esc_html_e('IMPORTANT! Only images that have been backed-up can be restored, so make sure you have the make backup button when compressing the images.', Advanced_Speed_Optimizer::$plugin_name ) ?></p>
					<p><?php esc_html_e('After you have compressed all the images, and you no longer need to restore them, you can delete the backups to clear some disk space on your server.', Advanced_Speed_Optimizer::$plugin_name ) ?></p>

				</div>
		   		<div class="clear"></div>
   			</div>

         <div class=" panel">
            <div class="panel-heading"><i class="icon-minus"></i> <?php esc_html_e('Restore backed-up images', Advanced_Speed_Optimizer::$plugin_name ) ?></div>
            <table class="table process_restore">
               <thead>
                  <tr class="first">
                     <th width="30">
                        <div class="md-checkbox">
                           <label class="col-lg-12">
                           <input type="checkbox" class="check_all_inputs form-check-input" checked="">
                           <i class="md-checkbox-control"></i>
                           </label>
                        </div>
                     </th>
                     <th class="mw200"><?php esc_html_e('Type', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                     <th class="w62p"  class=""><?php esc_html_e('Status', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                     <th class="tar mw100"><?php esc_html_e('Complete', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                  </tr>
               </thead>
               <tbody>
               	  <?php if($all_image_sizes): ?>
               	  	<?php foreach($all_image_sizes as $k => $img): ?>
		                  <tr class="tr_product_restore image_tr_<?php echo  esc_attr($k) ?>">
		                     <td>
		                        <div class="md-checkbox">
		                           <label class="col-lg-12">
		                           <input type="checkbox" class="check_image_restore form-check-input" checked="" value="<?php echo  esc_attr($k) ?>">
		                           <i class="md-checkbox-control"></i>
		                           </label>
		                          
		                           <input type="hidden" class="name_image_type" value="<?php echo  esc_attr($k) ?>">
		                        </div>
		                     </td>
		                     <td><?php esc_html_e($k) ?></td>
		                     <td>
		                        <div class="progress" max="<?php echo  esc_attr($img['count']) ?>">
		                           <div class="progress-bar process_product_restore" role="progressbar" style="width: <?php echo  esc_attr($img['restored_percent_done']) ?>%;">
		                           </div>
		                        </div>
		                     </td>
		                     <td   class="tar">
		                        <span class="status_product_restore"><?php esc_html_e($img['restored_percent_done']) ?></span>% | 
		                        <span class="complete_product_restore">
		                        <span class="total_product_success_restore">
		                        	<?php esc_html_e($img['restored_count']) ?>
		                        </span> /
		                        <span class="total_image_product_restore">
		                        <?php esc_html_e($img['count']) ?>
		                        </span>
		                        </span>
		                     </td>
		                  </tr>
              		<?php endforeach; ?>
					<tr>
						<td colspan="2">
							<div class="status_bar_image">
								<div class="lds-ellipsis restore_loading"><div></div><div></div><div></div><div></div></div>
								<button type="button" class="btn btn-default btn-custom restore_image ap_restore_backup"><i class="icon-refresh"></i> <?php esc_html_e('Restore backups', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
								<button type="button" class="btn btn-danger btn-custom remove_image ap_remove_backup"><i class="icon-refresh"></i> <?php esc_html_e('Remove backups', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
								<button type="button" class="btn btn-danger btn-stop stop_restore ap_stop_restore_backup"><i class="icon-stop"></i><?php esc_html_e('Stop backup restoration', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
							</div>
						</td>
						<td></td>
						<td    class="tar">
							<div class="status_bar_image">
								<button type="button" class="btn btn-danger btn-stop reset_restore ap_reset_restore_backup"><div alt="f531" class="dashicons dashicons-image-rotate"></div><?php esc_html_e('Reset', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
							</div>
						</td>
					</tr>
              	<?php endif; ?>

               </tbody>
            </table>
         </div>
      <div class="clear" style="clear:both"></div>
   </div>
   <div class="clear" style="clear:both"></div>
</div>