<?php 
/**
 *
 * @link       https://advancedplugins.com
 * @since      1.1.2
 * @author     Your Name office@advancedplugins.com
 */
	/* Get the neccesary data */

	$all_image_sizes = Advanced_Speed_Optimizer_Functions::get_all_image_sizes();
	$convert_future_images = (int)get_option('convert_future_images', 0);
	$convert_quality_arr = array(60,70,75,80,85,90,91,92,93,94,95,96,97,98,99,100);
	$convert_webp_quality = (int)get_option('convert_webp_quality', 70);
	$convert_change_extension = (int)get_option('convert_change_extension', 0);
	$convert_webp_status = (int)get_option('convert_webp_status', 0);
	$use_picture_format = (int)get_option('use_picture_format', 0);


	global $optimize_info;
	$optimize_info = array('type' => 'convert', 'title' => 'Convert');

?>

<div id="ap-image-convert" class="ap_wrapper bootstrap  ">
   <div class="tab-content ">
      <div id="regenerate" class="tab-pane active">

	<div class="panel">
		   <div class="panel-heading"><?php esc_html_e('Settings', Advanced_Speed_Optimizer::$plugin_name ) ?></div>
				<div class="alert alert-warning">
					<p><strong><?php esc_html_e('Important', Advanced_Speed_Optimizer::$plugin_name ) ?></strong></p>
					<hr>
					<p><strong><?php esc_html_e('Please read the documentation before you convert the images to understand the optimal process to convert the images, you can do this by pressing the `Documentation` button in the plugin menu', Advanced_Speed_Optimizer::$plugin_name ) ?></strong></p>
					
				</div>
		   		<div class="clear"></div>
				<table class="table">
			    	<tbody>
			    		<tr>
				    		<td>
				    			<label class="labelbutton"><?php esc_html_e('Display webp images', Advanced_Speed_Optimizer::$plugin_name ) ?></label>
				    		</td>
				    		<td>
								<label class="switch">
								  <input type="checkbox" class="update_option_switch" name="convert_webp_status" value="1" <?php if($convert_webp_status == 1): ?> checked<?php endif; ?>>
								  <span class="slider round "></span>
								</label>
				    		</td>
				    		<td><small><?php esc_html_e('Display webp images in your website', Advanced_Speed_Optimizer::$plugin_name ) ?></small></td>
			    		</tr>
			    		<tr>
				    		<td>
				    			<label class="labelbutton"><?php esc_html_e('Convert future images', Advanced_Speed_Optimizer::$plugin_name ) ?></label>
				    		</td>
				    		<td>
								<label class="switch">
								  <input type="checkbox" class="update_option_switch" name="convert_future_images" value="1" <?php if($convert_future_images == 1): ?> checked<?php endif; ?>>
								  <span class="slider round "></span>
								</label>
				    		</td>
				    		<td><small><?php esc_html_e('With this option active, future images will automatically be converted when uploaded, this will slow down your image upload process so turn this off when mass importing or it may cause timeout', Advanced_Speed_Optimizer::$plugin_name ) ?></small></td>
			    		</tr>
			    		<tr>
				    		<td>
				    			<label class="labelbutton"><?php esc_html_e('Change image extension', Advanced_Speed_Optimizer::$plugin_name ) ?></label>
				    		</td>
				    		<td>
								<label class="switch">
								  <input type="checkbox" class="update_option_switch" name="convert_change_extension" value="1" <?php if($convert_change_extension == 1): ?> checked<?php endif; ?>>
								  <span class="slider round "></span>
								</label>
				    		</td>
				    		<td><small><?php esc_html_e('With this option active, image extension is changed from .jpg/.png to .webp. We recommend only activating this if you use CloudFlare, Nginx or if does not work without it active. ', Advanced_Speed_Optimizer::$plugin_name ) ?></small><br/>
				    		<small><?php esc_html_e('You must NOT activate this option if you use a page cache module that saves pages as static files on the server or you will serve webp images to non supporting browsers and the images will not load.', Advanced_Speed_Optimizer::$plugin_name ) ?></small></td>
			    		</tr>
			    		<tr>
				    		<td>
				    			<label class="labelbutton"><?php esc_html_e('Use <Picture> Tag', Advanced_Speed_Optimizer::$plugin_name ) ?></label>
				    		</td>
				    		<td>
								<label class="switch">
								  <input type="checkbox" class="update_option_switch" name="use_picture_format" value="1" <?php if($use_picture_format == 1): ?> checked<?php endif; ?>>
								  <span class="slider round "></span>
								</label>
				    		</td>
				    		<td>
				    			<small><?php esc_html_e('This will add a `picture` wrapper to your elements', Advanced_Speed_Optimizer::$plugin_name ) ?></small><br/>
				    			<small><?php esc_html_e('For example < img src=”img.jpg” / > will be transformed to  < picture > < source srcset=”img.webp” type=”image/webp” > < img src=”img.png” alt=” ” > < /picture >', Advanced_Speed_Optimizer::$plugin_name ) ?></small><br/>
				    			<small><?php esc_html_e('Activate this version and disable ”Change image extension” and you can use it with a Cache plugin or Cloudflare, in rare cases this option can break javascript executed functionalities such as sliders/zoom/carousels so be sure to test it if you have such functionalities and disable it if it causes problems.', Advanced_Speed_Optimizer::$plugin_name ) ?></small><br/>
				    		</td>
			    		</tr>
			    		<tr>
				    		<td>
				    			<label class="labelbutton"><?php esc_html_e('WebP quality', Advanced_Speed_Optimizer::$plugin_name ) ?></label>
				    		</td>
				    		<td>
				    			<select name="convert_webp_quality" class="update_option_select">
				    				<?php foreach($convert_quality_arr as $cqa): ?>
				    					<option value="<?php echo  esc_attr($cqa) ?>" <?php if($cqa == $convert_webp_quality ) echo 'selected'; ?>><?php esc_html_e($cqa) ?>%</option>
				    				<?php endforeach; ?>
				    			</select>
							
				    		</td>
				    		<td><small><?php esc_html_e('The quality used to convert the image, a lower quality means more space saved but at the cost of image quality, usually 80% is the optimal image quality', Advanced_Speed_Optimizer::$plugin_name ) ?></small></td>
			    		</tr>
			    	</tbody>
				</table>
   			</div>

         <div class=" panel">

         	<div class="alert alert-info">
					<p><strong><?php esc_html_e('Why are existing images converted to webp manually?', Advanced_Speed_Optimizer::$plugin_name ) ?></strong></p>
					<hr>
					<ul>
						<li><small>- <?php esc_html_e('To allow the conversions of images at a different quality if the user considers it neccesary or has changed his mind', Advanced_Speed_Optimizer::$plugin_name ) ?></small></li>
						<li><small>- <?php esc_html_e('On most servers if the site has many images the PHP would reach it`s max execution time and timeout, as it can take hours for big images catalogs to be converted to webp; imagine, if you have 1000 images and 10 image sizes for each image, there would be 10.000 images to convert.', Advanced_Speed_Optimizer::$plugin_name ) ?></small></li>
					</ul>
					
				</div>

            <div class="panel-heading"><i class="icon-minus"></i> <?php esc_html_e('Convert existing media images', Advanced_Speed_Optimizer::$plugin_name ) ?></div>
            <table class="table process_webp">
               <thead>
                  <tr class="first">
                     <th width="30">
                        <div class="md-checkbox">
                           <label class="col-lg-12">
                           <input type="checkbox" class="check_all_inputs form-check-input" checked="">
                           <i class="md-checkbox-control"></i>
                           </label>
                        </div>
                     </th>
                     <th class="mw200"><?php esc_html_e('Type', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                     <th class="w62p"  class=""><?php esc_html_e('Status', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                     <th class="tar mw100"><?php esc_html_e('Complete', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                  </tr>
               </thead>
               <tbody>
               	  <?php if($all_image_sizes): ?>
               	  	<?php foreach($all_image_sizes as $k => $img): ?>
		                  <tr class="tr_product_webp image_tr_<?php echo  esc_attr($k) ?>">
		                     <td>
		                        <div class="md-checkbox">
		                           <label class="col-lg-12">
		                           <input type="checkbox" class="check_image_webp form-check-input" checked="" value="<?php echo  esc_attr($k) ?>">
		                           <i class="md-checkbox-control"></i>
		                           </label>
		                          
		                           <input type="hidden" class="name_image_type" value="<?php echo  esc_attr($k) ?>">
		                        </div>
		                     </td>
		                     <td><?php esc_html_e($k) ?></td>
		                     <td>
		                        <div class="progress" max="<?php echo  esc_attr($img['count']) ?>">
		                           <div class="progress-bar process_product_webp" role="progressbar" style="width: <?php echo  esc_attr($img['webp_percent_done']) ?>%;">
		                           </div>
		                        </div>
		                     </td>
		                     <td   class="tar">
		                        <span class="status_product_webp"><?php esc_html_e($img['webp_percent_done']) ?></span>% | 
		                        <span class="complete_product_webp">
		                        <span class="total_product_success_webp">
		                        	<?php esc_html_e($img['webp_count']) ?>
		                        </span> /
		                        <span class="total_image_product_webp">
		                        <?php esc_html_e($img['count']) ?>
		                        </span>
		                        </span>
		                     </td>
		                  </tr>
              		<?php endforeach; ?>
					<tr>
						<td colspan="2">
							<div class="status_bar_image">
								<div class="lds-ellipsis webp_loading"><div></div><div></div><div></div><div></div></div>
								<button type="button" class="btn btn-default btn-custom convert_image ap_convert_webp"><i class="icon-refresh"></i> <?php esc_html_e('Convert to WebP', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
								<button type="button" class="btn btn-danger btn-stop stop_webp  ap_stop_webp"><i class="icon-stop"></i><?php esc_html_e('Stop conversion', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
							</div>
						</td>
						<td></td>
						<td    class="tar">
							<div class="status_bar_image">
								<button type="button" class="btn btn-danger btn-stop reset_webp ap_reset_webp"><div alt="f531" class="dashicons dashicons-image-rotate"></div><?php esc_html_e('Reset', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
							</div>
						</td>
					</tr>
              	<?php endif; ?>

               </tbody>
            </table>
         </div>
      <div class="clear" style="clear:both"></div>
      <?php  require_once('advanced-speed-optimizer-folder.php');  ?>
      <div class="clear" style="clear:both"></div>
   </div>
   <div class="clear" style="clear:both"></div>
</div>