<?php

/**
 * Advanced Speed Optimizer
 *
 * Improve your page speed by compressing your images, convert them to WebP
 *
 * @link              https://advancedplugins.com
 * @since             1.1.2
 * @package           Advanced Speed Optimizer
 *
 * @wordpress-plugin
 * Plugin URI:        https://advancedplugins.com/advanced-image-optimizer/
 * Description:       Improve your page speed by compressing your images
 * Version:           1.1.2
 * Author:            Advanced Plugins
 * Plugin Name:       Advanced Speed Optimizer
 * Author URI:        https://advancedplugins.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       advanced-speed-optimizer
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
update_option('aso_cc_active', 1);
update_option('cc_key', '12345678901');
define( 'Advanced_Speed_Optimizer_VERSION', '1.1.2' );
define( 'Advanced_Speed_Optimizer_Plugin_Path', plugin_dir_path( __FILE__ ) );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-advanced-speed-optimizer-activator.php
 */

function Advanced_Speed_Optimizer_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-advanced-speed-optimizer-activator.php';
	Advanced_Speed_Optimizer_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-advanced-speed-optimizer-deactivator.php
 */
function Advanced_Speed_Optimizer_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-advanced-speed-optimizer-deactivator.php';
	Advanced_Speed_Optimizer_Deactivator::deactivate();
}


register_activation_hook( __FILE__, 'Advanced_Speed_Optimizer_activate' );
register_deactivation_hook( __FILE__, 'Advanced_Speed_Optimizer_deactivate' );


/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */

require plugin_dir_path( __FILE__ ) . 'includes/class-advanced-speed-optimizer-functions.php';
require plugin_dir_path( __FILE__ ) . 'includes/class-advanced-speed-optimizer.php';


/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.1.2
 */
function Advanced_Speed_Optimizer_run() {

	$plugin = new Advanced_Speed_Optimizer();
	$plugin->run();
}

Advanced_Speed_Optimizer_run();
