<?php

/**
 *
 * @link       https://advancedplugins.com
 * @since      1.1.2
 * @author     Your Name office@advancedplugins.com
 */


class Advanced_Speed_Optimizer_Ajax {

	public function  __construct() {

		add_action( 'wp_ajax_aso_compress_images', [$this, 'ajax_compress_images'] );
		add_action( 'wp_ajax_aso_restore_images', [$this, 'ajax_restore_images'] );
		add_action( 'wp_ajax_aso_removebk_images', [$this, 'ajax_remove_bk'] );
		add_action( 'wp_ajax_aso_webp_images', [$this, 'ajax_convert_webp'] );
		add_action( 'wp_ajax_aso_update_option', [$this, 'ajax_update_option'] );
		add_action( 'wp_ajax_aso_quality_test', [$this, 'ajax_quality_test'] );
		add_action( 'wp_ajax_get_subfolders', [$this, 'ajax_get_subfolders'] );
		add_action( 'wp_ajax_get_subfolders_and_images', [$this, 'ajax_get_subfolders_and_images'] );
		add_action( 'wp_ajax_optimize_in_folder', [$this, 'ajax_optimize_in_folder'] );
		add_action( 'wp_ajax_convert_in_folder', [$this, 'ajax_convert_in_folder'] );		
	}

	public function ajax_convert_in_folder(){

		$quality = (int)get_option('convert_webp_quality', 70);
		$answer = Advanced_Speed_Optimizer_Functions::convert_image_to_webp($_POST['path'], $quality);
		die(json_encode($answer));
	}

	public function ajax_optimize_in_folder(){

		$answer = Advanced_Speed_Optimizer_Functions::compress_image_by_folder($_POST['path']);
		die(json_encode($answer));
	}

	public function ajax_get_subfolders_and_images(){


		$folder = $_GET['folder'];

		if(empty( $_GET['folder']))
			$folder = get_home_path();

		$subdirectories =  Advanced_Speed_Optimizer_Functions::getDirContents($folder);

		if(!empty( $_GET['folder']))
			$subdirectories[] = $_GET['folder'];

		$allimages = array();

		if(!empty($subdirectories))
		{
			$subdirectories = array_unique($subdirectories);
		

			$allimages = Advanced_Speed_Optimizer_Functions::getAllImgs($subdirectories);
		}

		die(json_encode(array('error' => 0, 'images' => $allimages)));


	}

	public function ajax_get_subfolders(){

		$this->verify_activation();

		$folder = $_GET['folder'];

		if(empty( $_GET['folder'])){
			$folder = get_home_path();
		}

		$subdirectories =  Advanced_Speed_Optimizer_Functions::get_subdirectories($folder);
		$subdirectories = array_unique($subdirectories);
	
		if(!empty($subdirectories))
		{	echo '<ul>';
			foreach($subdirectories as $subdir)
			{
				$expl = explode('/', $subdir);
				echo ' <li  class="jstree-closed" rel="'.$subdir.'">'.end($expl).'</li>';
			}
			echo '</ul>';
		}

	}

	public function ajax_update_option()
	{

		if($_POST['option_name'] == 'cc_key' ){
		
			if(!current_user_can( 'manage_options' )){
				wp_die(
						json_encode(
								array(
									'error' => true,
									'message' => esc_html__('You do not have the permission to update the License Key, your role must have the manage_options capability.', Advanced_Speed_Optimizer::$plugin_slug)

								)
						)
					);
			}
		}

		update_option($_POST['option_name'], $_POST['option_value']) ;

		if(
				$_POST['option_name'] == 'convert_webp_status' || 
				$_POST['option_name'] == 'convert_change_extension' ||
				$_POST['option_name'] == 'aso_enable_gzip' ||
				$_POST['option_name'] == 'use_picture_format' ||
				$_POST['option_name'] == 'aso_enable_deflate'
			){
			$convert_webp_status = (int)get_option('convert_webp_status', 0);
			$convert_change_extension = (int)get_option('convert_change_extension', 0);

			
			$use_picture_format = (int)get_option('use_picture_format', 0);
			Advanced_Speed_Optimizer_Functions::remove_webp_htaccess_rules();

			if( $convert_webp_status == 1 && $use_picture_format == 0 && $convert_change_extension == 0)
				Advanced_Speed_Optimizer_Functions::insert_webp_htaccess_rules();
		}

		if($_POST['option_name'] == 'cc_key' ){


			$answer = Advanced_Speed_Optimizer_Functions::verify_activation_from_advancedplugins();
			if($answer)
			{
				if($answer['error'] == 0)
					update_option('aso_cc_active', 1);
				else
					update_option('aso_cc_active', 0);

				
				wp_die(
						json_encode(
								$answer
						)
					);
			}
		}

		wp_die(
				json_encode(
						array(
						'error' => false,
						'message' => esc_html($_POST['option_name']) .' ' .esc_html__('updated to ', Advanced_Speed_Optimizer::$plugin_slug) .' '. esc_html($_POST['option_value'])
					)
				)
			);
	}

	public function ajax_convert_webp(){

		$this->verify_activation();
		
		if(empty($_POST['elements_array']))
			wp_die(
				json_encode(
						array(
						'error' => true,
						'message' => esc_attr__('You must select one image size to compress', Advanced_Speed_Optimizer::$plugin_slug)
					)
				)
			);

		$compression_arr = Advanced_Speed_Optimizer_Functions::convert_image_sizes($_POST['elements_array']);
			
		wp_die(
				json_encode(
						array(
							'error' => false,
							'message' => esc_attr__('Images were converted to webp', Advanced_Speed_Optimizer::$plugin_slug),
							'object' => $compression_arr
						)
					)
			);

	}

	public function ajax_quality_test(){

		$this->verify_activation();

		$total_images = Advanced_Speed_Optimizer_Functions::attachment_count();

		$offset = rand(0, $total_images - 2);
		$image = Advanced_Speed_Optimizer_Functions::get_image($offset, 'ASC');
		$image_src = wp_get_attachment_image_src($image->ID, 'full');

		if(!isset($image_src[0]))
			wp_die(
					json_encode(
							array(
							'error' => true,
							'message' => esc_html__('Invalid image', Advanced_Speed_Optimizer::$plugin_slug)
						)
					)
				);


		$compressed_image = Advanced_Speed_Optimizer_Functions::get_optimized_image($image_src[0], $_POST['quality']);

		if(!$compressed_image)
			wp_die(
					json_encode(
							array(
							'error' => true,
							'message' => esc_html__('No answer received from the resmush.it server. Please try again', Advanced_Speed_Optimizer::$plugin_slug),
							'obj' => $compressed_image,
							'src' => $image_src
						)
					)
				);


		if(!empty($compressed_image['error']))
			wp_die(
					json_encode(
							array(
							'error' => true,
							'message' => esc_html__('There was an error when compressing your image. Please try again', Advanced_Speed_Optimizer::$plugin_slug),
							'obj' => $compressed_image,
							'src' => $image_src
						)
					)
				);



		if(!$compressed_image['object']['src'])
			wp_die(
					json_encode(
							array(
							'error' => true,
							'message' => esc_html__('There was an error when compressing your image. Please try again', Advanced_Speed_Optimizer::$plugin_slug),
							'obj' => $compressed_image,
							'src' => $image_src
						)
					)
				);


			wp_die(
					json_encode(
							array(
							'error' => false,
							'src' => $compressed_image['object']['src'],
							'src_size' => (int)($compressed_image['object']['src_size']/1024).' ' .esc_html__('kb ', Advanced_Speed_Optimizer::$plugin_slug),
							'dest' => $compressed_image['object']['dest'],
							'dest_size' =>  (int)($compressed_image['object']['dest_size']/1024).' ' .esc_html__('kb', Advanced_Speed_Optimizer::$plugin_slug)
						)
					)
				);
	}

	public function ajax_remove_bk(){

		$this->verify_activation();

		if(empty($_POST['elements_array']))
			wp_die(
				json_encode(
						array(
						'error' => true,
						'message' => esc_attr__('You must select one image size to remove', Advanced_Speed_Optimizer::$plugin_slug)
					)
				)
			);

		$compression_arr = Advanced_Speed_Optimizer_Functions::remove_bk_sizes($_POST['elements_array']);
		wp_die(
				json_encode(
						array(
							'error' => false,
							'message' => esc_attr__('Images backups were removed', Advanced_Speed_Optimizer::$plugin_slug),
							'object' => $compression_arr
						)
					)
				);	

	}

	private function verify_activation(){

		if(get_option('aso_cc_active', 0) == 0)
		{
			wp_die(
				json_encode(
						array(
						'error' => true,
						'message' => esc_attr__('You must first enter the plugin purchase code, in the Activation menu!', Advanced_Speed_Optimizer::$plugin_slug)
					)
				)
			);
		}
	}

	public function ajax_restore_images(){

		$this->verify_activation();

		if(empty($_POST['elements_array']))
			wp_die(
				json_encode(
						array(
						'error' => true,
						'message' => esc_attr__('You must select one image size to restore', Advanced_Speed_Optimizer::$plugin_slug)
					)
				)
			);

		$compression_arr = Advanced_Speed_Optimizer_Functions::restore_image_sizes($_POST['elements_array']);
		
		wp_die(
			json_encode(
					array(
						'error' => false,
						'message' => esc_attr__('Images were restored', Advanced_Speed_Optimizer::$plugin_slug),
						'object' => $compression_arr
					)
				)
			);

	}


	public function ajax_compress_images(){

		$this->verify_activation();

		if(empty($_POST['elements_array']))
			wp_die(
				json_encode(
						array(
						'error' => true,
						'message' => esc_attr__('You must select one image size to compress', Advanced_Speed_Optimizer::$plugin_slug)
					)
				)
			);

		$compression_arr = Advanced_Speed_Optimizer_Functions::compress_image_sizes($_POST['elements_array']);
		
		wp_die(
			json_encode(
					array(
						'error' => false,
						'message' => esc_attr__('Images were compressed', Advanced_Speed_Optimizer::$plugin_slug),
						'object' => $compression_arr
					)
				)
			);

	}
}