<?php

/**
 *
 * @link       https://advancedplugins.com
 * @since      1.1.2
 * @author     Your Name office@advancedplugins.com
 */

class Advanced_Speed_Optimizer {


	public static $plugin_name = 'Advanced Speed Optimizer';
	public static $plugin_slug = 'advanced-speed-optimizer';
	public static $plugin_path = '';

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.1.2
	 * @access   protected
	 * @var      Advanced_Speed_Optimizer_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */

	protected $loader;
	protected $Advanced_Speed_Optimizer;
	protected $version;

	public function __construct() {
		if ( defined( 'Advanced_Speed_Optimizer_VERSION' ) ) {
			$this->version = Advanced_Speed_Optimizer_VERSION;
		} else {
			$this->version = '1.1.2';
		}
		
		$this->Advanced_Speed_Optimizer = 'advanced-speed-optimizer';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();
		$this->load_ajax_hooks();

	}

	private function load_ajax_hooks()
	{
		require_once Advanced_Speed_Optimizer_Plugin_Path . 'includes/class-advanced-speed-optimizer-ajax.php';
		new Advanced_Speed_Optimizer_Ajax();

	}

	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-advanced-speed-optimizer-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-advanced-speed-optimizer-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-advanced-speed-optimizer-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-advanced-speed-optimizer-public.php';


		$this->loader = new Advanced_Speed_Optimizer_Loader();

	}

	private function set_locale() {

		$plugin_i18n = new Advanced_Speed_Optimizer_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.1.2
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Advanced_Speed_Optimizer_Admin( $this->Advanced_Speed_Optimizer_get(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'insert_menus' );
	}


	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.1.2
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Advanced_Speed_Optimizer_Public( $this->Advanced_Speed_Optimizer_get(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

	}


	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.1.2
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.1.2
	 * @return    string    The name of the plugin.
	 */
	public function Advanced_Speed_Optimizer_get() {
		return $this->Advanced_Speed_Optimizer;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.1.2
	 * @return    Advanced_Speed_Optimizer_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.1.2
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
