<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://advancedplugins.com
 * @since      1.1.2
 *
 * @package    Advanced_Speed_Optimizer
 * @subpackage Advanced_Speed_Optimizer/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Advanced_Speed_Optimizer
 * @subpackage Advanced_Speed_Optimizer/public
 * @author     Your Name office@advancedplugins.com
 */
class Advanced_Speed_Optimizer_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.1.2
	 * @access   private
	 * @var      string    $Advanced_Speed_Optimizer    The ID of this plugin.
	 */
	private $Advanced_Speed_Optimizer;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.1.2
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.1.2
	 * @param      string    $Advanced_Speed_Optimizer       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $Advanced_Speed_Optimizer, $version ) {

		$this->Advanced_Speed_Optimizer = $Advanced_Speed_Optimizer;
		$this->version = $version;
		$this->init_hooks();


	}

	public function web_support(){

        if ( (isset($_SERVER['HTTP_ACCEPT']) === true) &&  (false !== strpos($_SERVER['HTTP_ACCEPT'], 'image/webp'))   )
        {
            return true;
        }

        return false;

	}
	public function asoAlterHtml($content){

		require_once Advanced_Speed_Optimizer_Plugin_Path . 'includes/ImageUrlReplacer.php';
		$content = AsoImageUrlReplacer::replace($content);

		return $content;
	}

	public function asoOutputBuffer(){
	   
	   ob_start(array($this, 'asoAlterHtml'));

	}
	public function init_hooks(){


		if(is_admin())
			return false;

		$convert_change_extension = (int)get_option('convert_change_extension', 0);
		$convert_webp_status = (int)get_option('convert_webp_status', 0);
		$use_picture_format = (int)get_option('use_picture_format', 0);
		$aso_lazy_load = (int)get_option('aso_lazy_load', 0);


		if( (($convert_change_extension == 1 && $convert_webp_status == 1 && $this->web_support())  || ( $aso_lazy_load == 1 ) ||  ( $use_picture_format  == 1 && $convert_webp_status == 1) ) && !wp_doing_ajax())
			add_action( 'init', array($this, 'asoOutputBuffer'), 1 );

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.1.2
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Advanced_Speed_Optimizer_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Advanced_Speed_Optimizer_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->Advanced_Speed_Optimizer, plugin_dir_url( __FILE__ ) . 'css/advanced-speed-optimizer-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.1.2
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Advanced_Speed_Optimizer_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Advanced_Speed_Optimizer_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->Advanced_Speed_Optimizer, plugin_dir_url( __FILE__ ) . 'js/advanced-speed-optimizer-public.js', array( 'jquery' ), $this->version, false );

	}

}
